%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
if 1==0
    clear all
% generates random square for detectors ()
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dy=1000;  %distance between detectors

dsx=[3.1   6.6   2    4.6   2.6   5.6   ]; %size of waveguide holes 
dsy=[4   32  8  16   64  ];;  % size of detectors

myFileName='square1.txt';
fid = fopen(myFileName,'w');

myStart=0;

detectorJ=0;
x=x0; y=y0;

for j2=1:(-ymax/dy)
for j1=1:length(dx)

    detectorJ=detectorJ+1;
    if detectorJ>length(dsy)
        detectorJ=1;
    end
 a=[x-dsx(j1)/2 y-dsy(detectorJ) x+dsx(j1)/2 y];  % for cr         
%a=[x-dsx(j1)/2 y-dsy(detectorJ)/2 x+dsx(j1)/2 y+dsy(detectorJ)/2];
fprintf(fid,'\nadd %g. %g. %g. %g.\n',a)    ;
fprintf(fid,'\r')    ;

    x=x+dx(j1);
end
x=x0;
y=y-dy;
end

fclose(fid);
return
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
if 1==0
    clear all
% generates coordinate for detectors () for each detector length
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dy=1000;  %distance between detectors

dxNumber=5; %total 6 width of detector 1 to 6


myFileName='square1.txt';
fid = fopen(myFileName,'w');

myStart=0;

WaveguideN=0;
DetectorN=0;
x=x0; y=y0;

for j2=1:(-ymax/dy)
for j1=1:length(dx)


  DetectorN=DetectorN+1;;      
  if DetectorN>5;
       DetectorN=1;;
   end
  
    if DetectorN==dxNumber

 a=[x y ];  %         

fprintf(fid,'\nadd  %g. %g.\n',a)    ;
fprintf(fid,'\r')    ;

   
    end
 x=x+dx(j1);
end    
x=x0;
y=y-dy;
end


fclose(fid);
return
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
if 1==1
    clear all
% generates coordinate for detectors () for each waveguide
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dy=2000;  %distance between detectors

WaveguideNumber=6; %total 6 width of detector 1 to 6

x=0;
for j=1:WaveguideNumber-1
x=x+dx(j);
end
    
myFileName='square1.txt';
fid = fopen(myFileName,'w');

y=y0;

for j2=1:(-ymax/dy)

 a=[x y ];  %         

fprintf(fid,'\nadd  %g. %g.\n',a)    ;
fprintf(fid,'\r')    ;

y=y-dy;
end


fclose(fid);
return
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make single contact 
clear all
if 1==0
    clear all
% generates coordinate for detectors () for each detector length
x0=000;y0=-500;  % left position

ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dpad=[300 300  150  220  220 220]; %pad width
WavContactWidth=[2.3  2.7  1.3    2.3     1.9    2.3];


DetContactToCenter=[0  3.5  2   3.5   3.5]; %[0  3.5  2   3.5   3.5]; 
DetToContact=[1 4.5  3  4.5   4.5];%[1 4.5  3  4.5   4.5];
DetToFree=[1  1.5 1.5 1.5  1.5];%[1  1.5 1.5 1.5  1.5];

myFileName='square1.txt';
fid = fopen(myFileName,'w');

if 1==1    % only one
y0=0;
dpad=180;
DetContactToCenter=0;
DetToContact=1;
DetToFree=1;
end

jDetector=0;
for jy=0:0  %jy=-500:-1000:-16000
deltaX=0;
for jWaveguide=1:1   %jWaveguide=1:6
    jDetector=jDetector+1;
if jDetector>5
    jDetector=1;
end
    
pad=[ 9 1; 90 300; dpad(jWaveguide) 300; dpad(jWaveguide) 300; dpad(jWaveguide) -300; 90 -300; 9 -1];
pad1=pad;
pad1(:,2)=pad1(:,2)+DetContactToCenter(jDetector);

halfW=WavContactWidth(jWaveguide)/2;
topContact=[halfW DetContactToCenter(jDetector)-1; halfW  -DetToFree(jDetector); -halfW  -DetToFree(jDetector); -halfW  DetToContact(jDetector)]; 

myContact=[pad1; topContact; pad1(1,1) pad1(1,2)];
    
%dy=1000;  %distance between detectors

myContact(:,1)=myContact(:,1)+deltaX;

myContact(:,2)=myContact(:,2)+jy;



for j1=1:length(myContact(:,1))
a1=[myContact(j1,1) myContact(j1,2)];
fprintf(fid,'\nadd %g. %g.\n',a1)    ;
fprintf(fid,'\r')    ;
end
 fprintf(fid,'aput');



deltaX=deltaX+dx(jWaveguide);
end
end
fclose(fid);
return
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% make side contact 4 um long   3 um down from detector
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if 1==0
    clear all
% generates random square for detectors ()

sideLength=4; % um
sideDistance=2; %um
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dy=2000;  %distance between detectors

dsx=[3.1   6.6   2    4.6   2.6   5.6    ]; %size of waveguide holes 
dsy=[2.5   6   12    100];% [4   32  8  16   64  ];;  % size of detectors

myFileName='square1.txt';
fid = fopen(myFileName,'w');

myStart=0;

detectorJ=0;
x=x0; y=y0;

for j2=1:(-ymax/dy)
for j1=1:length(dx)

    detectorJ=detectorJ+1;
    if detectorJ>length(dsy)
        detectorJ=1;
    end
 a=[x-dsx(j1)/2 y-dsy(detectorJ)/2-sideDistance x+dsx(j1)/2 y-dsy(detectorJ)/2-sideDistance-sideLength];          
%a=[x-dsx(j1)/2 y-dsy(detectorJ)/2 x+dsx(j1)/2 y+dsy(detectorJ)/2];
if 1==0  %  
a=[x-dsx(j1)/2 y-dsy(detectorJ)/2-sideDistance x+dsx(j1)/2 y-dsy(detectorJ)/2-sideDistance-sideLength];
fprintf(fid,'\nadd %g. %g. %g. %g.\n',a)    ;
fprintf(fid,'\r')    ;
else % coordinate
      if j1==6  %coordinate of waveguide
 a=[x y-dsy(detectorJ)/2-sideDistance-sideLength/2  ];
 fprintf(fid,'\nadd %g.  %g.\n',a)    ;
fprintf(fid,'\r')    ;  
        end
end

    x=x+dx(j1);
end
x=x0;
y=y-dy;
end

fclose(fid);
return
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% make side contact 4 um long   3 um down from detector
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if 1==0
    clear all
% generates coordinate for  for side holes ()

sideLength=4; % um
sideDistance=2; %um
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dy=1000;  %distance between detectors

dsx=[2.5  3   1.5      3     2     3]; %[3.1   6.6   2    4.6   2.6   5.6    ]; %size of waveguide holes 
dsy=[4   32  8  16   64  ];;  % size of detectors

myFileName='square1.txt';
fid = fopen(myFileName,'w');

myStart=0;

detectorJ=0;
x=x0; y=y0;

for j2=1:(-ymax/dy)
for j1=1:length(dx)

    detectorJ=detectorJ+1;
    if detectorJ>length(dsy)
        detectorJ=1;
    end
    
    if j1==6
 a=[x  y-dsy(detectorJ)/2-sideDistance-sideLength/2];  % for cr         
%a=[x-dsx(j1)/2 y-dsy(detectorJ)/2 x+dsx(j1)/2 y+dsy(detectorJ)/2];

fprintf(fid,'\nadd %g.  %g.\n',a)    ;
fprintf(fid,'\r')    ;
end 
    x=x+dx(j1);
end
x=x0;
y=y-dy;
end

fclose(fid);
return
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make single contact  for double
clear all
if 1==0
    clear all
% generates coordinate for detectors () for each detector length
x0=000;y0=-500;  % left position

ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
dpad=[300 300  150  220  220 220]; %pad width
WavContactWidth=[2.3  2.7  1.3    2.3     1.9    2.3];


DetContactToCenter=[0    2    3.5    3.5]; %[0  3.5  2   3.5   3.5]; 
DetToContact=[1    3    4.5    4.5];%[1 4.5  3  4.5   4.5];
DetToFree=[1    1    1.5   1.5 ];%[1  1.5 1.5 1.5  1.5];

myFileName='square1.txt';
fid = fopen(myFileName,'w');

if 1==1    % only one
y0=0;
dpad=180;
DetContactToCenter=0;
DetToContact=1;
DetToFree=1;
end

jDetector=0;
for jy=0:0%-500:-2000:-16000
deltaX=0;
for jWaveguide=1:1%1:6
    jDetector=jDetector+1;
if jDetector>length(DetContactToCenter)
    jDetector=1;
end
    
%pad=[ 6 1; 90 400; dpad(jWaveguide) 400; dpad(jWaveguide) 300; dpad(jWaveguide) 100; 100 -1; 10 -1];
%pad1=pad;
%pad1(:,2)=pad1(:,2)+DetContactToCenter(jDetector);

pad1=[  90 400; dpad(jWaveguide) 400; dpad(jWaveguide) 300; dpad(jWaveguide) 100; 100 -1; 10 -1; 6 -1];

halfW=WavContactWidth(jWaveguide)/2;
topContact=[6 DetToContact(jDetector)-2;halfW DetToContact(jDetector)-2; halfW  -DetToFree(jDetector); -halfW  -DetToFree(jDetector); -halfW  DetToContact(jDetector); 6  DetToContact(jDetector)]; 

myContact=[pad1; topContact; pad1(1,1) pad1(1,2)];
    
%dy=1000;  %distance between detectors

myContact(:,1)=myContact(:,1)+deltaX;

myContact(:,2)=myContact(:,2)+jy;



for j1=1:length(myContact(:,1))
a1=[myContact(j1,1) myContact(j1,2)];
fprintf(fid,'\nadd %g. %g.\n',a1)    ;
fprintf(fid,'\r')    ;
end
 fprintf(fid,'aput');



deltaX=deltaX+dx(jWaveguide);
end
end
fclose(fid);
return
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make sub contact  for double

if 1==0
    clear all
sideLength=4; % um
sideDistance=2; %um
DistanceToNextContact=12;
x0=000;y0=-500;  % left position
ymax=-16000;  
dx= [400 400   200  300 300 300]; %distance between waveguides
pad=[300 300  150  220  220 220]; %pad width
dy=2000;  %distance between detectors

dsx=[3.1   6.6   2    4.6   2.6   5.6   ]; %size of waveguide holes 
dsy=[2.5   6   12    100  ];; %[4   32  8  16   64  ]; % size of detectors

myFileName='square1.txt';
fid = fopen(myFileName,'w');

myStart=0;

detectorJ=0;
x=x0; y=y0;

for j2=1:(-ymax/dy)
for j1=1:length(dx)

    detectorJ=detectorJ+1;
    if detectorJ>length(dsy)
        detectorJ=1;
    end
    
    
  SubDetectorCenter=y-dsy(detectorJ)/2  -sideDistance-sideLength/2;
UpDistance=y-DistanceToNextContact;;
  
%ContactPad=[8  SubDetectorCenter+1; -1  SubDetectorCenter+1; -1  SubDetectorCenter-1; 8  SubDetectorCenter-1;60 SubDetectorCenter-350; 60 SubDetectorCenter-350; pad(j1) SubDetectorCenter-350; pad(j1) SubDetectorCenter; 130 UpDistance;50 UpDistance];
ContactPad=[8  SubDetectorCenter+1; -1  SubDetectorCenter+1; -1  SubDetectorCenter-1; 8  SubDetectorCenter-1;60 SubDetectorCenter-350; 60 SubDetectorCenter-350; pad(j1) SubDetectorCenter-350; pad(j1) SubDetectorCenter; 130 SubDetectorCenter+1;50 SubDetectorCenter+1];
ContactPad(:,1)=ContactPad(:,1)+x;
myContact=[ContactPad; ContactPad(1,1)  ContactPad(1,2)];

for j7=1:length(myContact(:,1))
a1=[myContact(j7,1) myContact(j7,2)];
fprintf(fid,'\nadd %g. %g.\n',a1)    ;
fprintf(fid,'\r')    ;
end
 fprintf(fid,'aput');   ;

    x=x+dx(j1);
end
x=x0;
y=y-dy;
end

fclose(fid);
return
end